/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.ha;

import com.cloudbees.jenkins.ha.AbstractJenkinsSingleton;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TcpIdentityServer
extends Thread {
    private final ServerSocket ss;
    private final AbstractJenkinsSingleton singleton;
    private static final AtomicBoolean warned = new AtomicBoolean();
    private static final Logger LOGGER = Logger.getLogger(TcpIdentityServer.class.getName());

    @SuppressFBWarnings(value={"EI_EXPOSE_REP", "UNENCRYPTED_SERVER_SOCKET"}, justification="It initializes the variable, it does not mutate it afterwards as this is a constructor. ServerSocket used for loopbackAddress.")
    public TcpIdentityServer(AbstractJenkinsSingleton singleton) throws IOException {
        this.singleton = singleton;
        this.ss = new ServerSocket();
        InetAddress loopbackAddress = InetAddress.getLoopbackAddress();
        try {
            this.ss.bind(new InetSocketAddress(loopbackAddress, 0));
        }
        catch (IOException e) {
            throw (IOException)new IOException("Failed to bind to " + String.valueOf(loopbackAddress)).initCause(e);
        }
        this.setDaemon(true);
        this.setName("Jenkins cluster identity TCP socket server");
    }

    public int getLocalPort() {
        return this.ss.getLocalPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void run() {
        try {
            while (true) lbl-1000:
            // 4 sources

            {
                s = this.ss.accept();
                try {
                    s.shutdownInput();
                    o = s.getOutputStream();
                    c = this.singleton.getChannel();
                    if (c != null && (a = c.getAddress()) != null) {
                        o.write(a.toString().getBytes("UTF-8"));
                    }
                    o.close();
                }
                catch (IOException e) {
                    TcpIdentityServer.LOGGER.log(Level.INFO, "Cluster identity TCP socket failure", e);
                }
                finally {
                    s.close();
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            TcpIdentityServer.LOGGER.log(Level.SEVERE, "Failed to accept cluster identity TCP socket on " + String.valueOf(this.ss.getLocalSocketAddress()), e);
            try {
                this.ss.close();
            }
            catch (IOException e) {}
        }
        catch (Throwable e) {
            try {
                TcpIdentityServer.LOGGER.log(Level.SEVERE, "Cluster identity TCP socket failed", e);
            }
            catch (Throwable var6_11) {
                throw var6_11;
            }
            finally {
                try {
                    this.ss.close();
                }
                catch (IOException var1_5) {}
            }
        }
        ** GOTO lbl-1000
    }
}

