/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.ha.singleton;

import com.cloudbees.jenkins.ha.singleton.Identity;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jgroups.Address;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.ReceiverAdapter;
import org.jgroups.View;
import org.jgroups.stack.AddressGenerator;
import org.jgroups.util.StackType;
import org.jgroups.util.Util;

public abstract class HASingleton {
    protected static final String HA_JGROUPS_DIR = "HA_JGROUPS_DIR";
    protected volatile JChannel channel;
    protected ScheduledExecutorService taskExecutor;
    protected volatile Identity currentPrimary = null;
    private final Identity identity;
    private final Map<Address, Identity> members = new HashMap<Address, Identity>();
    private final ClassLoader classLoader;
    private static final Logger LOGGER = Logger.getLogger(HASingleton.class.getName());

    protected HASingleton(Identity identity) throws IOException {
        this.identity = identity;
        this.classLoader = identity.getClass().getClassLoader();
    }

    public Identity getIdentity() {
        return this.identity;
    }

    public void start() {
        this.members.put(this.identity.createAddress(), this.identity);
        this.taskExecutor = Executors.newScheduledThreadPool(1, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, "Jenkins Enterprise HA task thread");
                t.setDaemon(true);
                return t;
            }
        });
        try {
            this.channel = this.createChannel();
            this.channel.addAddressGenerator(new AddressGenerator(){

                @Override
                public Address generateAddress() {
                    return HASingleton.this.identity.getMember();
                }
            });
            this.channel.setReceiver(new ReceiverAdapter(){
                private Identity primary;

                @Override
                public void receive(Message msg) {
                    HASingleton.this.onMessage(msg);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public synchronized void viewAccepted(View view) {
                    LOGGER.info("Cluster membership has changed to: " + String.valueOf(view));
                    Map<Address, Identity> map = HASingleton.this.members;
                    synchronized (map) {
                        for (Address a : view) {
                            Identity id = HASingleton.this.members.get(a);
                            if (id != null) continue;
                            try {
                                id = Identity.fromAddress(a, HASingleton.this.classLoader);
                                HASingleton.this.members.put(a, id);
                            }
                            catch (Exception e) {
                                LOGGER.log(Level.SEVERE, "A member joined a cluster who doesn't speak the same protocol. Ignoring this node: " + String.valueOf(a), e);
                            }
                        }
                    }
                    final Identity o = this.primary;
                    final Identity n = this.electPrimary(view);
                    LOGGER.info("New primary node is " + String.valueOf(n));
                    this.primary = n;
                    HASingleton.this.taskExecutor.submit(new Runnable(){

                        @Override
                        public void run() {
                            HASingleton.this.reactToPrimarySwitch(o, n);
                        }
                    });
                }

                private Identity electPrimary(View view) {
                    int weight = Integer.MIN_VALUE;
                    Identity primary = null;
                    for (Address a : view) {
                        Identity i = HASingleton.this.members.get(a);
                        if (i == null) {
                            LOGGER.fine(String.valueOf(a) + " has no identity; skipping");
                            continue;
                        }
                        LOGGER.fine(String.valueOf(a) + " has weight " + i.getWeight());
                        if (i.getWeight() <= weight || view.size() < i.getMinimumSize()) continue;
                        primary = i;
                        weight = i.getWeight();
                    }
                    return primary;
                }

                @Override
                public void suspect(Address mbr) {
                    LOGGER.info("Suspecting a node failure in a cluster: " + String.valueOf(mbr));
                }
            });
            this.connect();
        }
        catch (Exception e) {
            throw new Error("Failed to form a cluster", e);
        }
    }

    public boolean isPrimary() {
        return this.currentPrimary == this.identity;
    }

    protected void reactToPrimarySwitch(Identity o, Identity n) {
        this.currentPrimary = n;
        if (n == null) {
            LOGGER.info("No primary in this cluster.");
            this.demote();
            return;
        }
        if (n == this.identity) {
            LOGGER.info("Elected as the primary node");
            try {
                this.sanityCheck();
                this.promote();
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Promotion failed. Bailing out to let another node take over", e);
                this.reconnect();
            }
        } else {
            if (!this.identity.isObserver()) {
                LOGGER.log(Level.INFO, "Elected as a backup node. Primary is {0}", n);
            }
            this.demote();
        }
    }

    protected void onMessage(Message msg) {
    }

    public boolean isObserverOnlyCluster() {
        return this.currentPrimary == null;
    }

    protected JChannel createChannel() throws Exception {
        URL u = HASingleton.class.getResource("jgroups-jenkins.xml");
        LOGGER.log(Level.INFO, "Loading default configuration from {0} using HA_JGROUPS_DIR={1}", new Object[]{u, System.getProperty(HA_JGROUPS_DIR)});
        return new JChannel(u);
    }

    protected abstract File jgroupsDir();

    public String getLockName() {
        return this.getClass().getName() + ".electionLock";
    }

    protected void stop() {
        if (this.channel != null) {
            this.channel.close();
            this.channel = null;
        }
        if (this.taskExecutor != null) {
            this.taskExecutor.shutdown();
            this.taskExecutor = null;
        }
    }

    private void connect() throws Exception {
        this.channel.connect(this.getClusterName());
    }

    protected void reconnect() {
        this.channel.close();
        try {
            this.connect();
        }
        catch (Exception x) {
            LOGGER.log(Level.WARNING, "Failed to reconnect to the cluster", x);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Identity getIdentityOf(Address address) {
        Map<Address, Identity> map = this.members;
        synchronized (map) {
            return this.members.get(address);
        }
    }

    protected abstract String getClusterName();

    protected void sanityCheck() throws Exception {
    }

    protected abstract void promote() throws Exception;

    protected abstract void demote();

    static {
        if (!Boolean.getBoolean(HASingleton.class.getName() + ".ipv6")) {
            try {
                Field f = Util.class.getDeclaredField("ip_stack_type");
                f.setAccessible(true);
                f.set(null, (Object)StackType.IPv4);
            }
            catch (Throwable e) {
                LOGGER.log(Level.WARNING, "Failed to force IPv4 on JGroups");
            }
        }
    }
}

