/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.ha.singleton;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class Config {
    private final DemoteAction demoteAction;

    @SuppressFBWarnings(value={"XXE_DOCUMENT"}, justification="Using FEATURE_SECURE_PROCESSING on dbf attribute")
    public Config(File configDir) throws IOException {
        DemoteAction _demoteAction = null;
        File configFile = new File(configDir, "high-availability.xml");
        if (configFile.exists()) {
            try {
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                dbf.setAttribute("http://javax.xml.XMLConstants/feature/secure-processing", true);
                Document doc = dbf.newDocumentBuilder().parse(configFile);
                NodeList nl = doc.getDocumentElement().getElementsByTagName("demoteAction");
                if (nl.getLength() == 1) {
                    _demoteAction = DemoteAction.valueOf(nl.item(0).getTextContent());
                }
            }
            catch (Exception x) {
                throw new IOException("Failed to load configuration from " + String.valueOf(configFile), x);
            }
        }
        this.demoteAction = _demoteAction;
    }

    public DemoteAction getDemoteAction() {
        return this.demoteAction != null ? this.demoteAction : DemoteAction.NOTHING;
    }

    public static enum DemoteAction {
        RESTART,
        EXIT,
        NOTHING;

    }
}

