/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.ha;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.PosixFilePermission;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.Security;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;

public class KeyStoreGenerator {
    private static final String SYM_ALG = "AES";
    private static int KEY_SIZE = 256;
    private static final String KEY_STORE_NAME = "jgroups_sym_encrypt.keystore";
    private static final String STORE_PASS = "changeit";
    private static final String ALIAS = "jgroupsKey";
    public static final String STORE_TYPE;
    public static final String JGROUPS_KEYSTORE_TYPE = "JGROUPS_KEYSTORE_TYPE";
    private static Logger LOGGER;

    private KeyStoreGenerator() {
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="We know what we are doing")
    public static void generateKey(File jenkinsHome) {
        File secretsDir;
        if (!jenkinsHome.isDirectory()) {
            throw new RuntimeException(String.format("%s is not a directory", jenkinsHome.getAbsolutePath()));
        }
        try {
            secretsDir = KeyStoreGenerator.getSecretsDirectory(jenkinsHome);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (Files.exists(Paths.get(secretsDir.getAbsolutePath(), KEY_STORE_NAME), new LinkOption[0])) {
            LOGGER.log(Level.FINE, "JGroups keystore file already exists. Skipping creation");
            return;
        }
        try {
            LOGGER.log(Level.INFO, String.format("Trying to create keystore file '%s' using algorithm '%s' size '%d'", KEY_STORE_NAME, SYM_ALG, KEY_SIZE));
            File tempKeystore = File.createTempFile("jgroups_sym_encrypt", ".keystore", Paths.get(secretsDir.getAbsolutePath(), new String[0]).toFile());
            try (FileOutputStream stream = new FileOutputStream(tempKeystore);){
                SecretKey key = KeyStoreGenerator.createSecretKey();
                KeyStore store = KeyStore.getInstance(STORE_TYPE);
                store.load(null, null);
                store.setKeyEntry(ALIAS, key, STORE_PASS.toCharArray(), null);
                store.store(stream, STORE_PASS.toCharArray());
            }
            try {
                Files.move(tempKeystore.toPath(), Paths.get(secretsDir.getAbsolutePath(), KEY_STORE_NAME), new CopyOption[0]);
                LOGGER.info("Keystore created successfully");
            }
            catch (FileAlreadyExistsException e) {
                LOGGER.log(Level.INFO, "Another HA node already created the keystore. Skipping creation.");
                LOGGER.log(Level.FINE, "Stacktrace", e);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static SecretKey createSecretKey() throws NoSuchAlgorithmException {
        KeyGenerator keyGen = KeyGenerator.getInstance(SYM_ALG);
        keyGen.init(KEY_SIZE);
        return keyGen.generateKey();
    }

    private static File getSecretsDirectory(File jenkinsHome) throws IOException {
        File secretsDir = new File(jenkinsHome, "secrets");
        if (secretsDir.exists() && secretsDir.isDirectory()) {
            return secretsDir;
        }
        if (secretsDir.mkdirs() && KeyStoreGenerator.isUnix()) {
            Files.setPosixFilePermissions(secretsDir.toPath(), Stream.of(PosixFilePermission.OWNER_EXECUTE, PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE).collect(Collectors.toCollection(HashSet::new)));
        }
        return secretsDir;
    }

    private static boolean isUnix() {
        return File.pathSeparatorChar != ';';
    }

    static {
        LOGGER = Logger.getLogger(KeyStoreGenerator.class.getName());
        STORE_TYPE = Security.getProvider("BCFIPS") != null ? "BCFKS" : "JCEKS";
    }
}

