/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.ha;

import com.cloudbees.jenkins.ha.JenkinsClusterMemberIdentity;
import com.cloudbees.jenkins.ha.KeyStoreGenerator;
import com.cloudbees.jenkins.ha.TcpIdentityServer;
import com.cloudbees.jenkins.ha.singleton.Config;
import com.cloudbees.jenkins.ha.singleton.HASingleton;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletContextEvent;
import jakarta.servlet.ServletContextListener;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.MessageDigest;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jgroups.Address;
import org.jgroups.JChannel;
import org.jgroups.View;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public abstract class AbstractJenkinsSingleton
extends HASingleton
implements ServletContextListener {
    private static final String OID_CLOUDBEES_PREFIX = "1.3.6.1.4.1.38143.";
    private static final String OID_JENKINS_ENTERPRISE_PREFIX = "1.3.6.1.4.1.38143.1.";
    private static final String OID_LICENSE_VERSION = "1.3.6.1.4.1.38143.1.1";
    private static final String OID_CLOUDBEES_PLUGIN_PACK_PREFIX = "1.3.6.1.4.1.38143.1.11.";
    private static final String OID_PACK_BUILD_MASTER_RESILIENCE = "1.3.6.1.4.1.38143.1.11.6";
    private static final String MCAST_PORT_PROPERTY = "jgroups.udp.mcast_port";
    private static final String HA_BIND_PORT = "HA_BIND_PORT";
    private static final String HA_PORT_RANGE = "HA_PORT_RANGE";
    private static final String HA_DIAGNOSTIC_PORT = "HA_DIAGNOSTIC_PORT";
    private static final String HA_TIMEOUT = "HA_TIMEOUT";
    private static final String USER_HOME = System.getProperty("user.home");
    protected ServletContext servletContext;
    protected File homeDir;
    private Config config;
    private String clusterId;
    private final TcpIdentityServer identityServer = new TcpIdentityServer(this);
    private static final String[] HOME_NAMES = new String[]{"JENKINS_HOME", "HUDSON_HOME"};
    private static final Logger LOGGER = Logger.getLogger(AbstractJenkinsSingleton.class.getName());

    @SuppressFBWarnings(value={"SC_START_IN_CTOR"}, justification="Fix it later - CJP-2546")
    public AbstractJenkinsSingleton(JenkinsClusterMemberIdentity identity) throws IOException {
        super(identity);
        int port;
        identity.identityPort = port = this.identityServer.getLocalPort();
        this.identityServer.start();
        LOGGER.log(Level.FINE, "Started identity server on port {0}", port);
    }

    protected void setHomeDir(File homeDir) {
        this.homeDir = homeDir;
    }

    public static AbstractJenkinsSingleton get(ServletContext context) {
        return (AbstractJenkinsSingleton)context.getAttribute(AbstractJenkinsSingleton.class.getName());
    }

    public static void set(ServletContext context, AbstractJenkinsSingleton singleton) {
        context.setAttribute(AbstractJenkinsSingleton.class.getName(), singleton);
    }

    @Override
    @SuppressFBWarnings(value={"WEAK_MESSAGE_DIGEST_MD5"}, justification="We are using MD5 to get a random unit port number.")
    protected JChannel createChannel() throws Exception {
        File stackDef;
        KeyStoreGenerator.generateKey(this.homeDir);
        if (System.getProperty(MCAST_PORT_PROPERTY) == null) {
            byte[] d = MessageDigest.getInstance("MD5").digest(this.getClusterName().getBytes("UTF-8"));
            int x = new BigInteger(d).abs().mod(new BigInteger("40000")).intValue();
            System.setProperty(MCAST_PORT_PROPERTY, String.valueOf(10000 + x));
            LOGGER.fine("Port set to " + (10000 + x));
        }
        if ((stackDef = new File(this.homeDir, "jgroups.xml")).exists()) {
            LOGGER.info("Loading cluster protocol setup from " + stackDef.getAbsolutePath());
            return new JChannel(stackDef.toURI().toURL());
        }
        if (System.getProperty("HA_JGROUPS_DIR") == null) {
            System.setProperty("HA_JGROUPS_DIR", this.jgroupsDir().getAbsolutePath());
        }
        System.setProperty("JGROUPS_KEYSTORE_TYPE", KeyStoreGenerator.STORE_TYPE);
        HAGlobalConfiguration haGlobalConfiguration = this.customizedConfiguration();
        String bindPort = null;
        String portRange = null;
        String diagnosticPort = null;
        if (haGlobalConfiguration != null) {
            if (haGlobalConfiguration.getBindPort() != 0) {
                bindPort = String.valueOf(haGlobalConfiguration.getBindPort());
                System.setProperty(HA_BIND_PORT, bindPort);
            }
            if (haGlobalConfiguration.getPortRange() != 0) {
                portRange = String.valueOf(haGlobalConfiguration.getPortRange());
                System.setProperty(HA_PORT_RANGE, portRange);
            }
            if (haGlobalConfiguration.getDiagnosticPort() != 0) {
                diagnosticPort = String.valueOf(haGlobalConfiguration.getDiagnosticPort());
                System.setProperty(HA_DIAGNOSTIC_PORT, diagnosticPort);
            }
            String timeout = String.valueOf(TimeUnit.SECONDS.toMillis(haGlobalConfiguration.getTimeout()));
            System.setProperty(HA_TIMEOUT, timeout);
            URL u = HASingleton.class.getResource("jgroups-jenkins-customized-ports.xml");
            LOGGER.log(Level.INFO, "Loading customized configuration from {0} using HA_JGROUPS_DIR={1}", new Object[]{u, System.getProperty("HA_JGROUPS_DIR")});
            if (LOGGER.isLoggable(Level.FINE)) {
                StringBuilder sb = new StringBuilder();
                if (bindPort != null) {
                    sb.append("HA_BIND_PORT=" + bindPort);
                }
                if (portRange != null) {
                    sb.append(",HA_PORT_RANGE=" + portRange);
                }
                if (diagnosticPort != null) {
                    sb.append(",HA_DIAGNOSTIC_PORT=" + diagnosticPort);
                }
                sb.append(",HA_TIMEOUT=" + timeout);
                LOGGER.log(Level.FINE, sb.toString());
            }
            return new JChannel(u);
        }
        return super.createChannel();
    }

    @SuppressFBWarnings(value={"XXE_DOCUMENT"}, justification="Using FEATURE_SECURE_PROCESSING on dbf attribute")
    private HAGlobalConfiguration customizedConfiguration() {
        File haGlobalConfig = new File(this.homeDir, "com.cloudbees.jenkins.ha.plugin.HAGlobalConfiguration.xml");
        if (!haGlobalConfig.exists() || !haGlobalConfig.isFile()) {
            LOGGER.log(Level.FINE, "{0} not found or invalid. Rolling back to the JGroups default Configuration", haGlobalConfig);
            return null;
        }
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setAttribute("http://javax.xml.XMLConstants/feature/secure-processing", true);
            Document doc = dbf.newDocumentBuilder().parse(haGlobalConfig);
            Function<String, Integer> child = field -> {
                NodeList nl = doc.getDocumentElement().getElementsByTagName((String)field);
                if (nl.getLength() == 1) {
                    return Integer.parseInt(nl.item(0).getTextContent());
                }
                return 0;
            };
            HAGlobalConfiguration haGlobalConfiguration = new HAGlobalConfiguration(child.apply("bindPort"), child.apply("portRange"), child.apply("diagnosticPort"), child.apply("timeout"));
            if (haGlobalConfiguration.isCustomized()) {
                return haGlobalConfiguration;
            }
            return null;
        }
        catch (Exception x) {
            LOGGER.log(Level.WARNING, null, x);
            return null;
        }
    }

    @Override
    protected File jgroupsDir() {
        return new File(this.homeDir, "jgroups");
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="To be fixed later - BEE-13918")
    JChannel getChannel() {
        return this.channel;
    }

    public boolean isUsingHA() {
        View view;
        JChannel c = this.channel;
        if (c != null && (view = c.getView()) != null) {
            return view.getMembers().size() > 1;
        }
        return false;
    }

    @Override
    public JenkinsClusterMemberIdentity getIdentity() {
        return (JenkinsClusterMemberIdentity)super.getIdentity();
    }

    @Override
    public JenkinsClusterMemberIdentity getIdentityOf(Address address) {
        return (JenkinsClusterMemberIdentity)super.getIdentityOf(address);
    }

    @Override
    public void contextInitialized(ServletContextEvent sce) {
        FileAndDescription home = this.getHomeDir(sce);
        LOGGER.log(Level.INFO, "Jenkins home directory: {0} found at: {1}", new Object[]{home.file, home.description});
        this.homeDir = home.file;
        try {
            this.config = this.createConfig();
        }
        catch (IOException e) {
            throw new Error("Failed to load configuration: " + String.valueOf(this.homeDir));
        }
        System.setProperty("JENKINS_HOME", this.homeDir.getAbsolutePath());
        if (System.getProperty("HA_JGROUPS_DIR") == null) {
            System.setProperty("HA_JGROUPS_DIR", this.jgroupsDir().getAbsolutePath());
        }
        this.clusterId = this.loadClusterId();
        this.servletContext = sce.getServletContext();
        this.start();
    }

    private String loadClusterId() {
        if (!new File(this.homeDir, "jgroups.xml").isFile()) {
            return "Jenkins";
        }
        File clusterIdFile = new File(this.homeDir, "cluster-identity.txt");
        try {
            for (int i = 0; i < 5; ++i) {
                if (clusterIdFile.exists()) {
                    String v = Files.readString(clusterIdFile.toPath()).trim();
                    if (v.length() == 36) {
                        return "Jenkins@" + v;
                    }
                    LOGGER.info(String.valueOf(clusterIdFile) + " contains garbage. A race condition?");
                } else {
                    File dir = clusterIdFile.getParentFile();
                    boolean ignored = dir.mkdirs();
                    if (!dir.exists()) {
                        throw new IOException("Failed to mkdir " + String.valueOf(dir) + ". Permission problem?");
                    }
                    if (clusterIdFile.createNewFile()) {
                        UUID uuid = UUID.randomUUID();
                        Files.writeString(clusterIdFile.toPath(), (CharSequence)uuid.toString(), StandardCharsets.UTF_8, new OpenOption[0]);
                        return "Jenkins@" + String.valueOf(uuid);
                    }
                    LOGGER.info("Failed to atomically create " + String.valueOf(clusterIdFile));
                }
                LOGGER.info("Waiting for 1s and retrying");
                Thread.sleep(1000L);
            }
        }
        catch (IOException e) {
            throw new Error("Failed to read/determine cluster ID with " + String.valueOf(clusterIdFile), e);
        }
        catch (InterruptedException e) {
            throw new Error("Unabled to determine cluster ID", e);
        }
        throw new Error("Unabled to determine cluster ID. Is " + String.valueOf(clusterIdFile) + " file writable?");
    }

    protected Config createConfig() throws IOException {
        return new Config(this.homeDir);
    }

    @Override
    public void contextDestroyed(ServletContextEvent sce) {
        this.demote();
        this.stop();
    }

    public Config getConfig() {
        return this.config;
    }

    @SuppressFBWarnings(value={"XSS_SERVLET"}, justification="We know what we are doing.")
    public void serveStandbyMessage(HttpServletResponse rsp) throws IOException {
        JChannel c = this.channel;
        rsp.setStatus(503);
        rsp.setContentType("text/plain;charset=UTF-8");
        if (c == null) {
            rsp.getOutputStream().println("Not joined to cluster (yet?)");
            return;
        }
        if (this.isPrimary()) {
            rsp.getOutputStream().println("Node " + c.getAddressAsString() + " is the primary of a cluster of " + c.getViewAsString() + ". Bringing up Jenkins");
        } else {
            rsp.getOutputStream().println("Node " + c.getAddressAsString() + " is standing by in a cluster of " + c.getViewAsString());
        }
    }

    @Override
    protected String getClusterName() {
        return this.clusterId;
    }

    protected String getInitParameter(String name, String defaultValue) {
        String v = this.servletContext.getInitParameter(name);
        if (v == null) {
            v = System.getProperty(name);
        }
        if (v == null) {
            v = defaultValue;
        }
        return v;
    }

    @Override
    @SuppressFBWarnings(value={"COMMAND_INJECTION"}, justification="We are injecting code to be executed.")
    protected void sanityCheck() throws Exception {
        File sanityCheckScript = new File(this.homeDir, "sanity-check.sh");
        if (sanityCheckScript.exists()) {
            LOGGER.info("Running sanity check script");
            Process p = new ProcessBuilder(sanityCheckScript.getPath()).directory(this.homeDir).redirectErrorStream(true).start();
            try {
                p.getOutputStream().close();
                p.getInputStream().transferTo(System.out);
                if (p.waitFor() != 0) {
                    throw new Error("Sanity check script failed");
                }
            }
            finally {
                p.getInputStream().close();
                p.getErrorStream().close();
            }
        }
        if (this.homeDir.listFiles() == null) {
            throw new IOException("cannot list " + String.valueOf(this.homeDir));
        }
        this.loadClusterId();
    }

    @Override
    protected final void demote() {
        this.doDemote();
        this.licenseCheck();
    }

    @SuppressFBWarnings(value={"XXE_DOCUMENT"}, justification="Using FEATURE_SECURE_PROCESSING on dbf attribute")
    protected void licenseCheck() {
        if (!this.isLicensingEnabled()) {
            LOGGER.log(Level.WARNING, "Licensing disabled");
            return;
        }
        File licenseXml = new File(this.homeDir, "license.xml");
        if (!licenseXml.isFile()) {
            LOGGER.log(Level.SEVERE, "{0} not found or invalid. Bailing out from a standby role", licenseXml);
            this.stop();
        } else {
            try {
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                dbf.setAttribute("http://javax.xml.XMLConstants/feature/secure-processing", true);
                Document doc = dbf.newDocumentBuilder().parse(licenseXml);
                NodeList nl = doc.getDocumentElement().getElementsByTagName("certificate");
                String certificate = nl.getLength() == 1 ? nl.item(0).getTextContent() : "";
                Certificate pemObject = this.loadPEM(certificate);
                if (pemObject == null) {
                    LOGGER.log(Level.SEVERE, String.format("%s not found or invalid. Bailing out from a standby role", licenseXml));
                    this.stop();
                    return;
                }
            }
            catch (Throwable e) {
                LOGGER.log(Level.SEVERE, String.format("%s not found or invalid. Bailing out from a standby role", licenseXml), e);
                this.stop();
            }
        }
    }

    @CheckForNull
    private Certificate loadPEM(String certificate) {
        try {
            CertificateFactory fact = CertificateFactory.getInstance("X.509");
            Certificate cert = fact.generateCertificate(new ByteArrayInputStream(certificate.getBytes(StandardCharsets.UTF_8)));
            return cert;
        }
        catch (CertificateException e) {
            LOGGER.log(Level.SEVERE, "Invalid certificate: " + e.getMessage());
            LOGGER.log(Level.FINE, "Invalid certificate.", e);
            return null;
        }
    }

    protected boolean isLicensingEnabled() {
        return !new File(USER_HOME, ".cloudbees-license").exists();
    }

    protected abstract void doDemote();

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="We know what we are doing")
    public FileAndDescription getHomeDir(ServletContextEvent event) {
        File ws;
        for (String name : HOME_NAMES) {
            try {
                InitialContext iniCtxt = new InitialContext();
                Context env = (Context)iniCtxt.lookup("java:comp/env");
                String value = (String)env.lookup(name);
                if (value != null && value.trim().length() > 0) {
                    return new FileAndDescription(new File(value.trim()), "JNDI/java:comp/env/" + name);
                }
                value = (String)iniCtxt.lookup(name);
                if (value == null || value.trim().length() <= 0) continue;
                return new FileAndDescription(new File(value.trim()), "JNDI/" + name);
            }
            catch (NamingException iniCtxt) {
                // empty catch block
            }
        }
        for (String name : HOME_NAMES) {
            String sysProp = System.getProperty(name);
            if (sysProp == null) continue;
            return new FileAndDescription(new File(sysProp.trim()), "System.getProperty(\"" + name + "\")");
        }
        for (String name : HOME_NAMES) {
            String env = System.getenv(name);
            if (env == null) continue;
            return new FileAndDescription(new File(env.trim()).getAbsoluteFile(), "EnvVars.masterEnvVars.get(\"" + name + "\")");
        }
        String root = event.getServletContext().getRealPath("/WEB-INF/workspace");
        if (root != null && (ws = new File(root.trim())).exists()) {
            return new FileAndDescription(ws, "getServletContext().getRealPath(\"/WEB-INF/workspace\")");
        }
        File legacyHome = new File(new File(USER_HOME), ".hudson");
        if (legacyHome.exists()) {
            return new FileAndDescription(legacyHome, "$user.home/.hudson");
        }
        File newHome = new File(new File(USER_HOME), ".jenkins");
        return new FileAndDescription(newHome, "$user.home/.jenkins");
    }

    public static class HAGlobalConfiguration {
        private static final int DEFAULT_TIMEOUT_SECONDS = 30;
        private final int bindPort;
        private final int portRange;
        private final int diagnosticPort;
        private final int timeout;

        public HAGlobalConfiguration(int bindPort, int portRange, int diagnosticPort, int timeout) {
            this.bindPort = bindPort;
            this.portRange = portRange;
            this.diagnosticPort = diagnosticPort;
            this.timeout = timeout == 0 ? 30 : timeout;
        }

        public int getBindPort() {
            return this.bindPort;
        }

        public int getPortRange() {
            return this.portRange;
        }

        public int getDiagnosticPort() {
            return this.diagnosticPort;
        }

        public boolean isCustomized() {
            return this.bindPort != 0 || this.portRange != 0 || this.diagnosticPort != 0 || this.timeout != 0 && this.timeout != 30;
        }

        public int getTimeout() {
            return this.timeout;
        }
    }

    public static class FileAndDescription {
        public final File file;
        public final String description;

        public FileAndDescription(File file, String description) {
            this.file = file;
            this.description = description;
        }
    }
}

