/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.ha;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;

@SuppressFBWarnings(value={"DMI_RANDOM_USED_ONLY_ONCE", "PREDICTABLE_RANDOM"}, justification="https://github.com/spotbugs/spotbugs/issues/1539. Demo code.")
public class LoggerConfigurator {
    private static final String LOG_ROTATION_ENABLED_PROP = "ha-troubleshooter.filelogging";
    private static final String LOG_ROTATION_FILES_COUNT_PROP = "ha-troubleshooter.filelogging.count";
    private static final Integer LOG_ROTATION_FILES_COUNT_DEFAULT = 10;
    private static final String LOG_ROTATION_FILE_SIZE_LIMIT_PROP = "ha-troubleshooter.filelogging.maxsize";
    private static final Integer LOG_ROTATION_FILE_SIZE_LIMIT_DEFAULT = 10000000;
    private static final String LOG_ROTATION_FILE_NAME_PROP = "ha-troubleshooter.filelogging.filename";
    private static final String LOG_ROTATION_FILE_NAME_DEFAULT = "ha-troubleshooting";
    private static final Integer UNIQUE_ID = new Random(System.currentTimeMillis()).nextInt(Short.MAX_VALUE);
    private static final String PREFIX = "logging.";
    private static final Logger LOGGER = Logger.getLogger(LoggerConfigurator.class.getName());

    public void apply() {
        this.enableLogRotation();
        this.apply(System.getenv());
        this.apply(System.getProperties());
        for (Handler h : Logger.getLogger("").getHandlers()) {
            h.setLevel(Level.ALL);
        }
    }

    private void apply(Map<?, ?> m) {
        for (Map.Entry<?, ?> e : m.entrySet()) {
            this.apply(e.getKey().toString(), e.getValue().toString());
        }
    }

    private boolean isLogRotationEnabled() {
        return System.getProperty(LOG_ROTATION_ENABLED_PROP) != null || System.getProperty(LOG_ROTATION_FILE_SIZE_LIMIT_PROP) != null || System.getProperty(LOG_ROTATION_FILES_COUNT_PROP) != null;
    }

    private void apply(String key, String value) {
        if (!key.startsWith(PREFIX)) {
            return;
        }
        key = key.substring(PREFIX.length());
        try {
            Level lv = Level.parse(value.toUpperCase(Locale.ENGLISH).trim());
            Logger.getLogger(key).setLevel(lv);
        }
        catch (IllegalArgumentException e) {
            LOGGER.log(Level.WARNING, "Failed to parse log level setting for " + key, e);
        }
    }

    private void enableLogRotation() {
        if (this.isLogRotationEnabled()) {
            System.out.printf("Logs File Rotation enabled: # of files: %s, max size per file: %s, pattern: %s%n", this.getRotatedFilesCount(), this.getRotatedFileSizeLimit(), this.getRotatedFilePattern());
            Properties props = new Properties();
            props.setProperty("handlers", "java.util.logging.ConsoleHandler, java.util.logging.FileHandler");
            props.setProperty("java.util.logging.FileHandler.limit", this.getRotatedFileSizeLimit());
            props.setProperty("java.util.logging.FileHandler.count", this.getRotatedFilesCount());
            props.setProperty("java.util.logging.FileHandler.pattern", this.getRotatedFilePattern());
            props.setProperty("java.util.logging.FileHandler.formatter", "java.util.logging.SimpleFormatter");
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try {
                props.store(out, "Well, no comment");
                LogManager.getLogManager().readConfiguration(new ByteArrayInputStream(out.toByteArray()));
            }
            catch (IOException e) {
                System.err.println("Something went wrong trying to configure the file rotation");
                e.printStackTrace();
            }
        }
    }

    private String getRotatedFilesCount() {
        return String.valueOf(Integer.getInteger(LOG_ROTATION_FILES_COUNT_PROP, LOG_ROTATION_FILES_COUNT_DEFAULT));
    }

    private String getRotatedFileSizeLimit() {
        return String.valueOf(Integer.getInteger(LOG_ROTATION_FILE_SIZE_LIMIT_PROP, LOG_ROTATION_FILE_SIZE_LIMIT_DEFAULT));
    }

    private String getRotatedFilePattern() {
        return String.format("%s.%04x.%%u.log", System.getProperty(LOG_ROTATION_FILE_NAME_PROP, LOG_ROTATION_FILE_NAME_DEFAULT), UNIQUE_ID);
    }
}

